<?php
/**
 * GET /api/captcha.php — Generate HMAC-signed math captcha
 * Fix #28: Token no longer contains a/b in plaintext.
 * Token format: "ts:hmac(answer:ts)" — the answer is not recoverable from the token.
 */
require_once __DIR__ . '/../includes/security.php';
$cfg = require __DIR__ . '/../includes/config.php';
$secret = 'inumbra-captcha-' . ($cfg['db_name'] ?? 'salt');

$a = rand(1, 30);
$b = rand(1, 30);
$answer = $a + $b;
$ts = time();
$hmac = hash_hmac('sha256', "$answer:$ts", $secret);
$token = "$ts:$hmac";

Security::json(['a' => $a, 'b' => $b, 'token' => $token]);
