<?php
/**
 * In Umbra — Dynamic XML Sitemap
 * Lists main views + top sites for AI and search crawlers
 */
header('Content-Type: application/xml; charset=utf-8');
require_once __DIR__ . '/../includes/db.php';
$cfg = require __DIR__ . '/../includes/config.php';
$db = DB::get();
$base = rtrim($cfg['site_url'] ?? 'https://inumbra.com', '/');
$now = date('Y-m-d');

echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  <url><loc><?= $base ?>/</loc><lastmod><?= $now ?></lastmod><changefreq>daily</changefreq><priority>1.0</priority></url>
  <url><loc><?= $base ?>/?v=newest</loc><lastmod><?= $now ?></lastmod><changefreq>hourly</changefreq><priority>0.8</priority></url>
  <url><loc><?= $base ?>/?v=changes</loc><lastmod><?= $now ?></lastmod><changefreq>hourly</changefreq><priority>0.8</priority></url>
  <url><loc><?= $base ?>/?v=tech</loc><lastmod><?= $now ?></lastmod><changefreq>weekly</changefreq><priority>0.7</priority></url>
  <url><loc><?= $base ?>/?v=lang</loc><lastmod><?= $now ?></lastmod><changefreq>weekly</changefreq><priority>0.7</priority></url>
  <url><loc><?= $base ?>/?v=canaries</loc><lastmod><?= $now ?></lastmod><changefreq>daily</changefreq><priority>0.7</priority></url>
  <url><loc><?= $base ?>/?v=mirrors</loc><lastmod><?= $now ?></lastmod><changefreq>daily</changefreq><priority>0.7</priority></url>
  <url><loc><?= $base ?>/?v=submit</loc><lastmod><?= $now ?></lastmod><changefreq>monthly</changefreq><priority>0.5</priority></url>
  <url><loc><?= $base ?>/?v=privacy</loc><lastmod><?= $now ?></lastmod><changefreq>monthly</changefreq><priority>0.4</priority></url>
  <url><loc><?= $base ?>/?v=terms</loc><lastmod><?= $now ?></lastmod><changefreq>monthly</changefreq><priority>0.4</priority></url>
  <url><loc><?= $base ?>/?v=removal</loc><lastmod><?= $now ?></lastmod><changefreq>monthly</changefreq><priority>0.4</priority></url>
<?php
// Top 200 sites by recency — gives crawlers individual pages to index
try {
    $st = $db->query("SELECT address, last_seen FROM onions WHERE status='online' ORDER BY last_seen DESC LIMIT 200");
    while ($row = $st->fetch()) {
        $addr = htmlspecialchars($row['address']);
        $mod = substr($row['last_seen'] ?? $now, 0, 10);
        echo "  <url><loc>{$base}/?v=detail&amp;addr={$addr}</loc><lastmod>{$mod}</lastmod><changefreq>daily</changefreq><priority>0.6</priority></url>\n";
    }
} catch (\Throwable $e) {}
?>
</urlset>
